/*
 * Use at your own risk.
 *
 * Copyright (C) 2005-2008 Sourcefire, Inc.
 * 
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>
 */


#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"


/* declare detection functions */
int rule15498eval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flowbits:isset "file.ppt"; */
static FlowBitsInfo rule15498flowbits0 =
{
    "file.ppt",
    FLOWBIT_ISSET,
    0,
};

static RuleOption rule15498option0 =
{
    OPTION_TYPE_FLOWBIT,
    {
        &rule15498flowbits0
    }
};
/* flow:established, to_client; */
static FlowFlags rule15498flow1 = 
{
    FLOW_ESTABLISHED|FLOW_TO_CLIENT
};

static RuleOption rule15498option1 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule15498flow1
    }
};
// content:"|E5 07|", depth 0; 
static ContentInfo rule15498content2 = 
{
    (uint8_t *) "|E5 07 00 00|", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_BUF_NORMALIZED|CONTENT_RELATIVE, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule15498option2 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule15498content2
    }
};

/* references for sid 15498 */
/* reference: cve "2009-1128"; */
static RuleReference rule15498ref1 = 
{
    "cve", /* type */
    "2009-1128" /* value */
};

/* reference: url "technet.microsoft.com/en-us/security/bulletin/MS09-017"; */
static RuleReference rule15498ref2 = 
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS09-017" /* value */
};

static RuleReference *rule15498refs[] =
{
    &rule15498ref1,
    &rule15498ref2,
    NULL
};
/* metadata for sid 15498 */
/* metadata:service http, policy balanced-ips drop, policy security-ips drop; */
static RuleMetaData rule15498service1 = 
{
    "service http"
};


//static RuleMetaData rule15498policy1 = 
//{
//    "policy balanced-ips drop"
//};
//
//static RuleMetaData rule15498policy2 = 
//{
//    "policy security-ips drop"
//};


static RuleMetaData *rule15498metadata[] =
{
    &rule15498service1,
//    &rule15498policy1,
//    &rule15498policy2,
    NULL
};

RuleOption *rule15498options[] =
{
    &rule15498option0,
    &rule15498option1,
    &rule15498option2,
    NULL
};

Rule rule15498 = {
   
   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "$HTTP_PORTS", /* SRCPORT   */
   
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
   
       "any", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid */
       15498, /* sigid */
       7, /* revision */
   
       "attempted-admin", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "FILE-OFFICE Microsoft PowerPoint CString atom overflow attempt",     /* message */
       rule15498refs /* ptr to references */
       ,rule15498metadata
   },
   rule15498options, /* ptr to rule options */
   &rule15498eval, /* use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
int rule15498eval(void *p) {
   const uint8_t *cursor_normal = 0;
   SFSnortPacket *sp = (SFSnortPacket *) p;

   const uint8_t *end_of_payload, *end_of_record;
   const uint8_t *cursor_detect, *cursor_temp;
   uint32_t recordlength;
   uint32_t atomlength;

   if(sp == NULL)
      return RULE_NOMATCH;

   if(sp->payload == NULL)
      return RULE_NOMATCH;
    
   // flowbits:isset "file.ppt";
   if(processFlowbits(p, rule15498options[0]->option_u.flowBit) <= 0) 
      return RULE_NOMATCH;

    // flow:established, to_client;
    if(checkFlow(p, rule15498options[1]->option_u.flowFlags) <= 0 ) 
      return RULE_NOMATCH;
   
    if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &cursor_normal, &end_of_payload) <= 0)
      return RULE_NOMATCH;

   // content:"|E5 07|", depth 0;
   while(contentMatch(p, rule15498options[2]->option_u.content, &cursor_normal) > 0) {
        
      if(cursor_normal + 24 > end_of_payload)
         return RULE_NOMATCH;

      cursor_detect = cursor_normal + 4;

      //Extract contrainer length
      recordlength = *cursor_detect++;
      recordlength |= *cursor_detect++ << 8;
      recordlength |= *cursor_detect++ << 16;
      recordlength |= *cursor_detect++ << 24;
      
      cursor_detect += 4;
      
      end_of_record = cursor_detect + recordlength;

      if(end_of_record > end_of_payload || end_of_record < cursor_detect)
         end_of_record = end_of_payload;

      while(cursor_detect + 12 < end_of_record) {

         //Extract length of record to jump to next recordtype
         cursor_detect += 8;
         atomlength = *cursor_detect++;
         atomlength |= *cursor_detect++ << 8;
         atomlength |= *cursor_detect++ << 16;
         atomlength |= *cursor_detect++ << 24;

         if(*(cursor_detect-12) == 0xba)
            if(*(cursor_detect-11/*+1*/) == 0x0f && atomlength > 255)
               return RULE_MATCH;

         cursor_temp = cursor_detect + atomlength + 4;
      
         // Overflow detection  
         cursor_detect = (cursor_detect < cursor_temp) ? cursor_temp : end_of_record; 
      }
      
   }
        
   return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &rule15498,
    NULL
};
*/

